/*
 * Decompiled with CFR 0.152.
 */
package cz.sycha.clm;

import java.util.logging.Logger;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Main
extends JavaPlugin
implements Listener {
    private static final Logger log = Logger.getLogger("minecraft");
    private static final String version = "1.5";

    public void onEnable() {
        this.getConfig().options().copyDefaults(true);
        this.saveConfig();
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        log.info("Plugin Custom Login Messages v1.5 loaded!");
    }

    public void onDisable() {
        log.info("Plugin Custom Login Messages v1.5 nloaded!");
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerJoin(PlayerJoinEvent e) {
        String message = this.getConfig().getString("join-message");
        message = message.replace('&', '\u00a7');
        message = message.replace("%p", e.getPlayer().getDisplayName());
        e.setJoinMessage(message);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerQuit(PlayerQuitEvent e) {
        String message = this.getConfig().getString("leave-message");
        message = message.replace('&', '\u00a7');
        message = message.replace("%p", e.getPlayer().getDisplayName());
        e.setQuitMessage(message);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerKick(PlayerKickEvent e) {
        String message = this.getConfig().getString("kick-message");
        message = message.replace('&', '\u00a7');
        message = message.replace("%p", e.getPlayer().getDisplayName());
        e.setLeaveMessage(message);
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (sender.hasPermission("clm.admin") && cmd.getName().equalsIgnoreCase("clm")) {
            if (args.length == 0) {
                sender.sendMessage(ChatColor.GOLD + "-------------------------------------------");
                sender.sendMessage(ChatColor.AQUA + "Custom Login Messages " + ChatColor.RED + "v" + ChatColor.GOLD + version);
                sender.sendMessage(ChatColor.AQUA + "List of available commands:");
                sender.sendMessage(ChatColor.DARK_PURPLE + "- /clm reload : " + ChatColor.AQUA + "Reload the config");
                sender.sendMessage(ChatColor.GOLD + "-------------------------------------------");
                return true;
            }
            if (args.length == 1 && args[0].equalsIgnoreCase("reload")) {
                this.reloadConfig();
                sender.sendMessage(ChatColor.AQUA + "Custom login messages config has been reloaded!");
                return true;
            }
        }
        return false;
    }
}

