/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.anvillogin;

import fr.xephi.authme.api.v3.AuthMeApi;
import net.wesjd.anvilgui.AnvilGUI;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class AnvilLogin
extends JavaPlugin
implements Listener {
    private AuthMeApi authmeApi;
    private String insert;
    private String wrongPassword;

    public void onEnable() {
        if (this.getServer().getPluginManager().getPlugin("AuthMe") == null) {
            return;
        }
        this.authmeApi = AuthMeApi.getInstance();
        this.saveDefaultConfig();
        this.insert = this.c(this.getConfig().getString("insert"));
        this.wrongPassword = this.c(this.getConfig().getString("wrong-password"));
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getServer().getOnlinePlayers().forEach(this::ask);
    }

    private String c(String text) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)text);
    }

    private void ask(Player player) {
        if (this.authmeApi.isRegistered(player.getName())) {
            this.openLogin(player);
        } else {
            this.openRegister(player);
        }
    }

    private void openLogin(Player p) {
        AnvilGUI.Builder builder = new AnvilGUI.Builder().onComplete((player, s) -> {
            if (!this.authmeApi.checkPassword(player.getName(), s)) {
                return AnvilGUI.Response.text(this.wrongPassword);
            }
            this.authmeApi.forceLogin(player);
            return AnvilGUI.Response.close();
        }).preventClose().text(this.insert).plugin((Plugin)this);
        this.getServer().getScheduler().runTask((Plugin)this, () -> builder.open(p));
    }

    private void openRegister(Player p) {
        AnvilGUI.Builder builder = new AnvilGUI.Builder().onComplete((player, s) -> {
            this.authmeApi.registerPlayer(player.getName(), s);
            if (!this.authmeApi.isAuthenticated(player)) {
                this.authmeApi.forceLogin(player);
            }
            return AnvilGUI.Response.close();
        }).preventClose().text(this.insert).plugin((Plugin)this);
        this.getServer().getScheduler().runTask((Plugin)this, () -> builder.open(p));
    }

    @EventHandler
    public void join(PlayerJoinEvent event) {
        this.ask(event.getPlayer());
    }
}

