/*
 * Decompiled with CFR 0.152.
 */
package net.islandearth.anvillogin.util;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.islandearth.anvillogin.util.Colors;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class ItemStackBuilder {
    private final ItemStack ITEM_STACK;

    public static ItemStackBuilder of(ItemStack item) {
        return new ItemStackBuilder(item);
    }

    public static ItemStackBuilder of(Material material) {
        return new ItemStackBuilder(material);
    }

    public ItemStackBuilder(Material material) {
        this.ITEM_STACK = new ItemStack(material);
    }

    public ItemStackBuilder(ItemStack item) {
        this.ITEM_STACK = item;
    }

    public ItemStackBuilder withAmount(int amount) {
        this.ITEM_STACK.setAmount(amount);
        return this;
    }

    public ItemStackBuilder withName(String name) {
        ItemMeta meta = this.ITEM_STACK.getItemMeta();
        meta.setDisplayName(Colors.color(name));
        this.ITEM_STACK.setItemMeta(meta);
        return this;
    }

    public ItemStackBuilder withLore(String name) {
        ItemMeta meta = this.ITEM_STACK.getItemMeta();
        ArrayList<String> lore = meta.getLore();
        if (lore == null) {
            lore = new ArrayList<String>();
        }
        lore.add(Colors.color(name));
        meta.setLore(lore);
        this.ITEM_STACK.setItemMeta(meta);
        return this;
    }

    public ItemStackBuilder withLore(List<String> name) {
        if (name == null) {
            return this;
        }
        ItemMeta meta = this.ITEM_STACK.getItemMeta();
        List<String> lore = meta.getLore();
        if (lore == null) {
            lore = name;
        } else {
            lore.addAll(name);
        }
        meta.setLore(lore);
        this.ITEM_STACK.setItemMeta(meta);
        return this;
    }

    public ItemStackBuilder withDurability(int durability) {
        ItemMeta meta = this.ITEM_STACK.getItemMeta();
        Damageable damageable = (Damageable)meta;
        damageable.setDamage(durability);
        this.ITEM_STACK.setItemMeta(meta);
        return this;
    }

    public ItemStackBuilder addFlags(ItemFlag ... flags) {
        ItemMeta meta = this.ITEM_STACK.getItemMeta();
        meta.addItemFlags(flags);
        this.ITEM_STACK.setItemMeta(meta);
        return this;
    }

    public ItemStackBuilder withSkullOwner(OfflinePlayer player) {
        Material type = this.ITEM_STACK.getType();
        if (type == Material.PLAYER_HEAD) {
            ItemMeta meta = this.ITEM_STACK.getItemMeta();
            SkullMeta skullMeta = (SkullMeta)meta;
            skullMeta.setOwningPlayer(player);
            this.ITEM_STACK.setItemMeta(meta);
            return this;
        }
        throw new IllegalArgumentException("withSkullOwner is only applicable for skulls!");
    }

    public ItemStackBuilder setSkullOwner(UUID uuid) {
        Material type = this.ITEM_STACK.getType();
        if (type == Material.PLAYER_HEAD) {
            ItemMeta meta = this.ITEM_STACK.getItemMeta();
            SkullMeta skullMeta = (SkullMeta)meta;
            skullMeta.setOwningPlayer(Bukkit.getOfflinePlayer((UUID)uuid));
            return this;
        }
        throw new IllegalArgumentException("withSkullOwner is only applicable for skulls!");
    }

    public ItemStackBuilder withModel(int model) {
        ItemMeta meta = this.ITEM_STACK.getItemMeta();
        meta.setCustomModelData(Integer.valueOf(model));
        this.ITEM_STACK.setItemMeta(meta);
        return this;
    }

    public ItemStackBuilder withEnchantment(Enchantment enchantment, int level) {
        this.ITEM_STACK.addUnsafeEnchantment(enchantment, level);
        return this;
    }

    public ItemStackBuilder withEnchantment(Enchantment enchantment) {
        this.ITEM_STACK.addUnsafeEnchantment(enchantment, 1);
        return this;
    }

    public ItemStackBuilder withType(Material material) {
        this.ITEM_STACK.setType(material);
        return this;
    }

    public ItemStackBuilder clearLore() {
        ItemMeta meta = this.ITEM_STACK.getItemMeta();
        meta.setLore(new ArrayList());
        this.ITEM_STACK.setItemMeta(meta);
        return this;
    }

    public ItemStackBuilder clearEnchantments() {
        for (Enchantment enchantment : this.ITEM_STACK.getEnchantments().keySet()) {
            this.ITEM_STACK.removeEnchantment(enchantment);
        }
        return this;
    }

    public ItemStackBuilder withColor(Color color) {
        Material type = this.ITEM_STACK.getType();
        if (type == Material.LEATHER_BOOTS || type == Material.LEATHER_CHESTPLATE || type == Material.LEATHER_HELMET || type == Material.LEATHER_LEGGINGS) {
            LeatherArmorMeta meta = (LeatherArmorMeta)this.ITEM_STACK.getItemMeta();
            meta.setColor(color);
            this.ITEM_STACK.setItemMeta((ItemMeta)meta);
            return this;
        }
        throw new IllegalArgumentException("withColor is only applicable for leather armor!");
    }

    public ItemStack build() {
        return this.ITEM_STACK;
    }
}

