/*
 * Decompiled with CFR 0.152.
 */
package net.islandearth.anvillogin.translation;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import me.clip.placeholderapi.PlaceholderAPI;
import net.islandearth.anvillogin.AnvilLogin;
import net.islandearth.anvillogin.libs.languagy.api.language.Language;
import net.islandearth.anvillogin.libs.languagy.api.language.key.LanguageKey;
import net.islandearth.anvillogin.libs.languagy.api.language.key.TranslationKey;
import net.islandearth.anvillogin.libs.languagy.api.language.translation.Translation;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public enum Translations {
    KICKED(TranslationKey.of("kicked")),
    LOGGED_IN(TranslationKey.of("logged_in")),
    GUI_TITLE(TranslationKey.of("gui_title")),
    GUI_TEXT(TranslationKey.of("gui_text")),
    GUI_WRONG(TranslationKey.of("gui_wrong"));

    private final TranslationKey key;
    private final boolean isList;

    private Translations(TranslationKey key) {
        this.key = key;
        this.isList = false;
    }

    public boolean isList() {
        return this.isList;
    }

    private String getPath() {
        return this.toString().toLowerCase();
    }

    public void send(Player player, Object ... values) {
        Translation translation = AnvilLogin.getAPI().getTranslator().getTranslationFor(player, this.key);
        for (String translationString : translation.colour()) {
            player.sendMessage(this.setPapi(player, this.replaceVariables(translationString, values)));
        }
    }

    public List<String> get(Player player, Object ... values) {
        Translation translation = AnvilLogin.getAPI().getTranslator().getTranslationFor(player, this.key);
        ArrayList<String> transformed = new ArrayList<String>();
        for (String translationString : translation.colour()) {
            transformed.add(this.setPapi(player, this.replaceVariables(translationString, values)));
        }
        return transformed;
    }

    public static void generateLang(AnvilLogin plugin) {
        File lang = new File(plugin.getDataFolder() + "/lang/");
        lang.mkdirs();
        for (Language language : Language.values()) {
            LanguageKey languageKey = language.getKey();
            try {
                plugin.saveResource("lang/" + languageKey.getCode() + ".yml", false);
                plugin.getLogger().info("Generated " + languageKey.getCode() + ".yml");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            File file = new File(plugin.getDataFolder() + "/lang/" + languageKey.getCode() + ".yml");
            if (!file.exists()) continue;
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
            for (Translations key : Translations.values()) {
                if (config.get(key.toString().toLowerCase()) != null) continue;
                plugin.getLogger().warning("No value in translation file for key " + key + " was found. Please regenerate or edit your language files with new values!");
            }
        }
    }

    private String replaceVariables(String message, Object ... values) {
        String modifiedMessage = message;
        for (int i = 0; i < 10 && values.length > i; ++i) {
            modifiedMessage = modifiedMessage.replaceAll("%" + i, String.valueOf(values[i]));
        }
        return modifiedMessage;
    }

    private String setPapi(Player player, String message) {
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            return PlaceholderAPI.setPlaceholders((Player)player, (String)message);
        }
        return message;
    }
}

