/*
 * Decompiled with CFR 0.152.
 */
package net.islandearth.anvillogin.libs.languagy.api.language.translation;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.islandearth.anvillogin.libs.languagy.api.language.Language;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;

public class Translation {
    private final Player player;
    private final Language language;
    private final List<String> translations;

    private Translation(Player player, Language language, List<String> translations) {
        this.player = player;
        this.language = language;
        this.translations = translations;
    }

    public static Translation of(Player player, Language language, String translation) {
        return new Translation(player, language, Lists.newArrayList((Object[])new String[]{translation}));
    }

    public static Translation of(Player player, Language language, List<String> translations) {
        return new Translation(player, language, translations);
    }

    public Language getLanguage() {
        return this.language;
    }

    public void send() {
        this.colour().forEach(arg_0 -> ((Player)this.player).sendMessage(arg_0));
    }

    public void format(Object ... values) {
        this.translations.replaceAll(s -> String.format(Locale.ROOT, s, values));
    }

    public List<String> getTranslations() {
        return this.translations;
    }

    public List<String> colour() {
        ArrayList colouredText = Lists.newArrayList();
        this.translations.forEach(translation -> {
            if (!translation.isEmpty()) {
                colouredText.add(this.colour((String)translation));
            }
        });
        return colouredText;
    }

    private String colour(String text) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)text);
    }
}

