/*
 * Decompiled with CFR 0.152.
 */
package net.islandearth.anvillogin;

import com.google.common.base.Enums;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.islandearth.anvillogin.api.AnvilLoginAPI;
import net.islandearth.anvillogin.libs.anvilgui.version.VersionMatcher;
import net.islandearth.anvillogin.libs.languagy.api.language.Language;
import net.islandearth.anvillogin.libs.languagy.api.language.Translator;
import net.islandearth.anvillogin.listeners.PlayerListener;
import net.islandearth.anvillogin.translation.Translations;
import org.bukkit.Bukkit;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class AnvilLogin
extends JavaPlugin
implements AnvilLoginAPI {
    private final List<UUID> loggedIn = new ArrayList<UUID>();
    private final List<UUID> notLoggedIn = new ArrayList<UUID>();
    private Translator translator;
    private boolean authme;
    private static AnvilLogin plugin;

    public List<UUID> getLoggedIn() {
        return this.loggedIn;
    }

    public List<UUID> getNotLoggedIn() {
        return this.notLoggedIn;
    }

    @Override
    public Translator getTranslator() {
        return this.translator;
    }

    public boolean isAuthme() {
        return this.authme;
    }

    public void onEnable() {
        try {
            new VersionMatcher().match();
        }
        catch (RuntimeException e) {
            this.getLogger().severe("Your server version is not supported! Please update to the latest version!");
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        if (Bukkit.getPluginManager().getPlugin("AuthMe") != null) {
            this.getLogger().info("Found authme!");
            this.authme = true;
        } else {
            this.authme = false;
        }
        plugin = this;
        this.createFiles();
        Language defaultLanguage = (Language)((Object)Enums.getIfPresent(Language.class, (String)this.getConfig().getString("default_language", "ENGLISH")).or((Object)Language.ENGLISH));
        this.translator = Translator.of((Plugin)this, "lang", defaultLanguage, this.debug());
        this.registerListeners();
        this.getLogger().info("[AnvilLogin] Enabled & registered events!");
    }

    public void onDisable() {
        if (this.translator != null) {
            this.translator.close();
        }
    }

    private void createFiles() {
        this.saveDefaultConfig();
        Translations.generateLang(this);
    }

    private void registerListeners() {
        PluginManager pm = Bukkit.getPluginManager();
        pm.registerEvents((Listener)new PlayerListener(this), (Plugin)this);
    }

    public boolean debug() {
        return this.getConfig().getBoolean("debug");
    }

    public static AnvilLoginAPI getAPI() {
        return plugin;
    }
}

